<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Admin\Routes\PonghoRoute;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Routing\RoutesCollection;

class RoutingServiceProvider implements ServiceProviderInterface
{
    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->extend(
            'routes_collection',
            function (RoutesCollection $collection, Container $di) {
                if ($collection->has('pongho')) {
                    $collection->del('pongho');
                }

                if (substr($di->getService('request')->getPathInfo(), 0, 8) === '/pongho/') {
                    $route = new PonghoRoute(
                        $di->getService('admin_sidebar'),
                        $di->getService('current_user'),
                        $di->getService('main_site'),
                        $di->getService('pongho_url')
                    );

                    $collection->add('pongho', $route, -10);
                }
            }
        );
    }
}
