<?php

/**
 * Questo file è parte di admin-bar.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Admin\Dashboard\Widget\KeywordsReportWidget;
use Application\Admin\Dashboard\Widget\LocationsReportWidget;
use Application\Admin\Dashboard\Widget\PageviewsReportWidget;
use Application\Admin\Dashboard\Widget\VisitsReportWidget;
use Application\Admin\Widget\StatsWidget;
use Application\Admin\Widget\WidgetsCollection;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * DashboardWidgetsServiceProvider
 */
class DashboardWidgetsServiceProvider implements ServiceProviderInterface
{
    /**
     * @var array
     */
    protected static $sharedServices = array();

    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->setService('admin_dashboard_widgets', array($this, 'getWidgetsCollectionService'));

        $container->setService('admin_dashboard_visits_report_widget', array($this, 'getVisitsReportWidget'));
        $container->setService('admin_dashboard_locations_report_widget', array($this, 'getLocationsReportWidget'));
        $container->setService('admin_dashboard_keywords_report_widget', array($this, 'getKeywordsReportWidget'));
        $container->setService('admin_dashboard_page_views_report_widget', array($this, 'getPageViewsReportWidget'));
        $container->setService('admin_dashboard_stats_widget', array($this, 'getStatsWidget'));
    }

    /**
     * @param Container $container
     * @return WidgetsCollection
     */
    public function getWidgetsCollectionService(Container $container)
    {
        if (!array_key_exists('admin_dashboard_widgets', static::$sharedServices)) {
            $widgets = new WidgetsCollection();

            /** @var \Application\Core\User $user */
            $user = $container->getService('current_user');

            /** @var \Application\Core\Model\Site $site */
            $site = $container->getService('site');

            if (($site->getOption('google_analytics') !== 'UA-XXXXX-XX')) {
                if ($user->hasPermit('admin.dashboard.widget_visitsreport')) {
                    $widgets->add($container->getService('admin_dashboard_visits_report_widget'));
                }

                if ($user->hasPermit('admin.dashboard.widget_locationsreport')) {
                    $widgets->add($container->getService('admin_dashboard_locations_report_widget'));
                }

                if ($user->hasPermit('admin.dashboard.widget_keywordsreport')) {
                    $widgets->add($container->getService('admin_dashboard_keywords_report_widget'));
                }

                if ($user->hasPermit('admin.dashboard.widget_pageviewsreport')) {
                    $widgets->add($container->getService('admin_dashboard_page_views_report_widget'));
                }
            }

            if ($user->hasPermit('admin.dashboard.widget_statsreport')) {
                $widgets->add($container->getService('admin_dashboard_stats_widget'));
            }

            /** @var \Application\Core\Utilities\ControllerHelper $helper */
            $helper = $container->getService('controller_helper');

            /** @var WidgetsCollection $widgets */
            $widgets = $helper->filter($this, 'admin.dashboard.filter_widget_collection', $widgets);

            $widgets->setHeaders();

            static::$sharedServices['admin_dashboard_widgets'] = $widgets;
        }

        return static::$sharedServices['admin_dashboard_widgets'];
    }

    /**
     * @param Container $container
     * @return VisitsReportWidget
     */
    public function getVisitsReportWidget(Container $container)
    {
        if (!array_key_exists('admin_dashboard_widgets', static::$sharedServices)) {
            static::$sharedServices['admin_dashboard_widgets'] = new VisitsReportWidget($container);
        }

        return static::$sharedServices['admin_dashboard_widgets'];
    }

    /**
     * @param Container $container
     * @return VisitsReportWidget
     */
    public function getLocationsReportWidget(Container $container)
    {
        if (!array_key_exists('admin_dashboard_locations_report_widget', static::$sharedServices)) {
            static::$sharedServices['admin_dashboard_locations_report_widget'] = new LocationsReportWidget($container);
        }

        return static::$sharedServices['admin_dashboard_locations_report_widget'];
    }

    /**
     * @param Container $container
     * @return VisitsReportWidget
     */
    public function getKeywordsReportWidget(Container $container)
    {
        if (!array_key_exists('admin_dashboard_keywords_report_widget', static::$sharedServices)) {
            static::$sharedServices['admin_dashboard_keywords_report_widget'] = new KeywordsReportWidget($container);
        }

        return static::$sharedServices['admin_dashboard_keywords_report_widget'];
    }

    /**
     * @param Container $container
     * @return VisitsReportWidget
     */
    public function getPageViewsReportWidget(Container $container)
    {
        if (!array_key_exists('admin_dashboard_page_views_report_widget', static::$sharedServices)) {
            static::$sharedServices['admin_dashboard_page_views_report_widget'] = new PageviewsReportWidget($container);
        }

        return static::$sharedServices['admin_dashboard_page_views_report_widget'];
    }

    /**
     * @param Container $container
     * @return VisitsReportWidget
     */
    public function getStatsWidget(Container $container)
    {
        if (!array_key_exists('admin_dashboard_stats_widget', static::$sharedServices)) {
            static::$sharedServices['admin_dashboard_stats_widget'] = new StatsWidget($container);
        }

        return static::$sharedServices['admin_dashboard_stats_widget'];
    }
}
