<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author  Daniele Termini
 * @package Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Admin\AdminSidebar\Sidebar;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

class AdminSidebarServiceProvider implements ServiceProviderInterface
{
    protected static $shared = array();

    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->setService('admin_sidebar', array($this, 'getAdminSidebarService'));
    }

    /**
     * Restituisce il servizio per la sidebar di Pongho.
     *
     * @param Container $container
     * @return Sidebar
     */
    public function getAdminSidebarService(Container $container)
    {
        if (!array_key_exists('admin_sidebar', static::$shared)) {
            /** @var \Application\Core\I18n\Translator\Translator $translator */
            $translator = $container->getService('translator');

            /** @var \Application\Core\User $user */
            $user = $container->getService('current_user');

            $sidebar = new Sidebar(
                $container->getService('site'),
                $container->getService('request'),
                $container->getService('pongho_url')
            );

            // Dashboard
            $sidebar->addPanel($translator->trans('Dashboard'), 'dashboard', 'dashboard', Sidebar::POS_DASHBOARD);
            $sidebar->addItem(
                $translator->trans('Dashboard'),
                '/',
                'dashboard',
                0,
                'Application\Admin\Controller\DashboardController'
            );

            if ($user->hasPermit('admin.options')) {
                $sidebar->addPanel($translator->trans('Options'), 'options', 'settings', Sidebar::POS_SETTINGS);
            }

            if ($user->isFounder()) {
                $sidebar->addPanel($translator->trans('Settings'), 'settings', 'settings', Sidebar::POS_SETTINGS);
            }

            // Rotte per la gestione del multisito e dei widget in bacheca.
            $sidebar->addRoute('/widget/', 'Application\\Admin\\Controller\\WidgetsController');

            static::$shared['admin_sidebar'] = $sidebar;
        }

        return static::$shared['admin_sidebar'];
    }
}
