<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Admin\Utilities\AdminControllerHelper;
use Application\Admin\Utilities\ContentLanguage;
use Application\Admin\Utilities\PonghoUrl;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;
use Pongho\Template\Theme;

/**
 * Class AdminServicesProvider
 */
class AdminServicesProvider implements ServiceProviderInterface
{
    protected static $shared = array();

    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->setService('admin_controller_helper', array($this, 'getAdminControllerHelperService'));
        $container->setService('pongho_url', array($this, 'getPonghoUrlService'));
        $container->setService('content_language', array($this, 'getContentLanguageService'));

        $container->extend('theme_view', function (Theme $theme) {
            $theme->setOption(
                'image_sizes',
                array_merge(
                    $theme->getOption('image_sizes', array()),
                    array(
                        'adminfeatured'  => array(260, 300, 'auto'),
                        'adminslide'     => array(120, 70, 'auto'),
                        'adminpreview'   => array(100, 100, 'crop'),
                        'adminproduct'   => array(80, 80, 'fill'),
                        'adminbaravatar' => array(20, 20, 'fill'),
                    )
                )
            );
        });
    }

    /**
     * @param Container $container
     * @return AdminControllerHelper
     */
    public function getAdminControllerHelperService(Container $container)
    {
        if (!array_key_exists('admin_controller_helper', static::$shared)) {
            $service = new AdminControllerHelper($container);

            static::$shared['admin_controller_helper'] = $service;
        }

        return static::$shared['admin_controller_helper'];
    }

    /**
     * @param Container $container
     * @return ContentLanguage
     */
    public function getContentLanguageService(Container $container)
    {
        if (!array_key_exists('content_language', static::$shared)) {
            $service = new ContentLanguage(
                $container->getService('site'),
                $container->getService('request')
            );

            static::$shared['content_language'] = $service;
        }

        return static::$shared['content_language'];
    }

    /**
     * @param Container $container
     * @return PonghoUrl
     */
    public function getPonghoUrlService(Container $container)
    {
        if (!array_key_exists('pongho_url', static::$shared)) {
            $service = new PonghoUrl(
                $container->getService('site'),
                $container->getService('request'),
                $container->getService('content_language')
            );

            static::$shared['pongho_url'] = $service;
        }

        return static::$shared['pongho_url'];
    }
}
