<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\DependencyInjection;

use Application\Admin\AdminBar\AdminBar;
use Application\Admin\AdminBar\AdminBarBuilder;
use Application\Admin\AdminBar\AdminBarRenderer;
use Application\Admin\AdminBar\Filler\AdminFiller;
use Application\Admin\AdminBar\Filler\DbProfilerFiller;
use Application\Admin\AdminBar\Filler\UserFiller;
use Pongho\DependencyInjection\Container;
use Pongho\DependencyInjection\ServiceProviderInterface;

/**
 * AdminBarServiceProvider
 */
class AdminBarServiceProvider implements ServiceProviderInterface
{
    /**
     * @var array
     */
    protected static $sharedServices = array();

    /**
     * {@inheritdoc}
     */
    public function register(Container $container)
    {
        $container->setService('admin_bar', array($this, 'getAdminBarService'));
        $container->setService('admin_bar_builder', array($this, 'getAdminBarBuilderService'));
        $container->setService('admin_bar_renderer', array($this, 'getAdminBarRendererService'));

        $container->setService('admin_bar_admin_filler', array($this, 'getAdminBarAdminFillerService'));
        $container->setService('admin_bar_user_filler', array($this, 'getAdminBarUserFillerService'));
        $container->setService('admin_bar_db_profiler_filler', array($this, 'getAdminDbProfilerFillerService'));
    }

    /**
     * @return AdminBar
     */
    public function getAdminBarService()
    {
        if (!array_key_exists('admin_bar', static::$sharedServices)) {
            static::$sharedServices['admin_bar'] = new AdminBar();
        }

        return static::$sharedServices['admin_bar'];
    }

    /**
     * @param Container $container
     * @return AdminBarBuilder
     */
    public function getAdminBarBuilderService(Container $container)
    {
        if (!array_key_exists('admin_bar_builder', static::$sharedServices)) {
            /** @var \Application\Core\User $user */
            $user = $container->getService('current_user');

            /** @var \Pongho\Core\Kernel $kernel */
            $kernel = $container->getService('kernel');

            $builder = new AdminBarBuilder($container->getService('admin_bar'));

            $builder->add($container->getService('admin_bar_admin_filler'));
            $builder->add($container->getService('admin_bar_user_filler'));

            if ($user->isFounder() && $kernel->isDebug()) {
                $builder->add($container->getService('admin_bar_db_profiler_filler'));
            }

            static::$sharedServices['admin_bar_builder'] = $builder;
        }

        return static::$sharedServices['admin_bar_builder'];
    }

    /**
     * @param Container $container
     * @return AdminBarRenderer
     */
    public function getAdminBarRendererService(Container $container)
    {
        if (!array_key_exists('admin_bar_renderer', static::$sharedServices)) {
            static::$sharedServices['admin_bar_renderer'] = new AdminBarRenderer(
                $container->getService('admin_bar_builder')
            );
        }

        return static::$sharedServices['admin_bar_renderer'];
    }

    /**
     * @param Container $container
     * @return AdminFiller
     */
    public function getAdminBarAdminFillerService(Container $container)
    {
        if (!array_key_exists('admin_bar_admin_filler', static::$sharedServices)) {
            static::$sharedServices['admin_bar_admin_filler'] = new AdminFiller(
                $container->getService('site'),
                $container->getService('current_user'),
                $container->getService('translator'),
                $container->getService('site_manager')
            );
        }

        return static::$sharedServices['admin_bar_admin_filler'];
    }

    /**
     * @param Container $container
     * @return AdminFiller
     */
    public function getAdminBarUserFillerService(Container $container)
    {
        if (!array_key_exists('admin_bar_user_filler', static::$sharedServices)) {
            static::$sharedServices['admin_bar_user_filler'] = new UserFiller(
                $container->getService('site'),
                $container->getService('current_user'),
                $container->getService('translator')
            );
        }

        return static::$sharedServices['admin_bar_user_filler'];
    }

    /**
     * @param Container $container
     * @return AdminFiller
     */
    public function getAdminDbProfilerFillerService(Container $container)
    {
        if (!array_key_exists('admin_bar_db_profiler_filler', static::$sharedServices)) {
            static::$sharedServices['admin_bar_db_profiler_filler'] = new DbProfilerFiller(
                $container->getService('db_profiler')
            );
        }

        return static::$sharedServices['admin_bar_db_profiler_filler'];
    }
}
