<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Application\Admin
 */

namespace Application\Admin\Dashboard\Widget;

use Application\Admin\Widget\Widget;
//use Application\Admin\Dashboard\Widget\Gapi\Gapi;
use Pongho\Http\Request;

/**
 * Base per i widget basati su Google Analytics.
 */
abstract class GoogleAnalyticsWidget extends Widget
{
	/**
	 * Istanza all’interfaccia per le API di Google Analytics.
	 *
	 * @access protected
	 * @var \gapi
	 */
	protected static $gapi_instance;

	/**
	 * Parametro e-mail per l’accesso alle API.
	 *
	 * @access private
	 * @var string
	 *
	 * @ignore
	 */
	private $email = 'webagencymetaline@gmail.com';

	/**
	 * Parametro password per l’accesso alle API.
	 *
	 * @access private
	 * @var string
	 *
	 * @ignore
	 */
	private $password = 'ildebrando';

    /**
     * Restituisce l’istanza dell’interfaccia per le API di Google Analytics.
     *
     * @access protected
     * @throws \RuntimeException
     * @return \gapi
     */
	protected function getGapiInstance()
	{
		if ( self::$gapi_instance === null )
		{
			$site = $this->container->getService('site');

			if ( $site->getOption('gapi_profile_id') === '' )
			{
				throw new \RuntimeException(sprintf('Missing Google Analytics Api parameters!'));
			}

			require PONGHO_PATH . '/vendor/gapi/gapi.class.php';
			self::$gapi_instance = new \gapi($site->getOption('gapi_email'), $site->getOption('gapi_password'));
		}

		return self::$gapi_instance;
	}

	/**
	 * Restituisce l’ID del profilo verso il quale richiedere le statistiche.
	 *
	 * @access protected
	 * @return string
	 */
	protected function getGapiProfile()
	{
		return $this->container->getService('site')->getOption('gapi_profile_id');
	}

	/**
	 * {@inheritdoc}
	 */
	public function render()
	{
		$head = $this->container->getService('template_head');
		$head->addJavascriptInline("window.google || document.write('<script src=\"https://www.google.com/jsapi\">\\x3C/script>');");

		return '';
	}

	/**
	 * {@inheritdoc}
	 */
	public function handleRequest(Request $request)
	{
		$segments = explode('/', trim(substr($request->getPathInfo(), 15), '/'));

		if ( isset($segments[1]) && ($method = $segments[1] . 'RequestHandler') && method_exists($this, $method) )
		{
			return $this->$method($request);
		}

		return parent::handleRequest($request);
	}
}
