<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Controller;

use Pongho\Http\Exception\HttpNotFoundException;

/**
 * WidgetsController
 */
class WidgetsController extends AdminController
{
    public function indexAction()
    {
        throw new HttpNotFoundException();
    }

    /**
     * @param string $method
     * @param array  $args
     * @return \Pongho\Http\Response
     */
    public function __call($method, array $args)
    {
        if (substr($method, -6) !== 'Action') {
            throw new HttpNotFoundException();
        }

        $widget_name = substr($method, 0, -6);

        try {
            $widget = $this->getWidgetsCollection()->get($widget_name);
        } catch (\InvalidArgumentException $e) {
            throw new HttpNotFoundException();
        }

        return $widget->handleRequest($this->getRequest());
    }

    /**
     * Restituisce l’elenco dei widget.
     *
     * @return \Application\Admin\Widget\WidgetsCollection
     */
    protected function getWidgetsCollection()
    {
        return $this->getContainer()->getService('admin_dashboard_widgets');
    }
}
