<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author  Daniele De Nobili
 * @package Application\Admin
 */

namespace Application\Admin\Controller;

use Application\Admin\Panels\PanelsManager;

/**
 * Controller per la bacheca.
 */
abstract class StatsController extends AdminController
{
    /**
     * @param string $method
     * @param array  $args
     * @return null
     */
    public function __call($method, array $args)
    {
        if (substr($method, -6) !== 'Action') {
            throw new \BadMethodCallException(sprintf('Method %s::%s not found!', __CLASS__, $method));
        }

        $tab_name = substr($method, 0, -6);

        return $this->view($tab_name);
    }

    /**
     * @param string $tab
     * @return null
     */
    protected function view($tab = null)
    {
        $panels_manager = $this->getPanelsManager();

        if ($tab) {
            $panels_manager->setActive($tab);
        }

        $this->getHelper()->getBodyView()
            ->assignVars(
                array(
                    'title'   => $this->getTitle(),
                    'content' => $panels_manager->render(),
                )
            )
            ->setTemplatePath(__DIR__ . '/../Resources/views/view.php');

        $this->getHelper()->getHead()->addCss(pongho_url('/Application/Admin/Resources/views/css/widgets.css'));

        return null;
    }

    /**
     * @return string
     */
    abstract protected function getTitle();

    /**
     * @return PanelsManager
     */
    abstract protected function getPanelsManager();
}
