<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\AdminBar;

use Application\Core\Entity\SiteInterface;
use Application\Core\I18n\Translator\Translator;
use Pongho\Menu\Item;
use Pongho\Menu\Menu;

/**
 * SiteMenu.
 *
 * Rappresenta il menu di un singolo sito.
 */
class SiteMenu extends Menu
{
	/**
	 * @param SiteInterface $site
	 * @param Translator    $translator
	 */
	public function __construct(SiteInterface $site, Translator $translator)
	{
		parent::__construct($site->getName());

		$this->add(new Item($translator->trans('Dashboard'), pongho_url('/?site=' . $site->getId())), 0);
		$this->add(new Item($translator->trans('Go to site'), $site->getPermalink()), 999);
	}
}
