<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\AdminBar\Filler;

use Application\Admin\AdminBar\AdminBar;
use Application\Admin\AdminBar\FillerInterface;
use Application\Admin\AdminBar\SiteMenu;
use Application\Core\Entity\SiteInterface;
use Application\Core\I18n\Translator\Translator;
use Application\Core\Model\Manager\SiteManagerInterface;
use Application\Core\User;
use Pongho\Menu\Item;
use Pongho\Menu\Menu;

/**
 * AdminFiller
 */
class AdminFiller implements FillerInterface
{
    /**
     * @var SiteInterface
     */
    protected $site;

    /**
     * @var User
     */
    protected $user;

    /**
     * @var Translator
     */
    protected $translator;

    /**
     * @var SiteManagerInterface
     */
    protected $site_manager;

    /**
     * @param SiteInterface        $site
     * @param User                 $user
     * @param Translator           $translator
     * @param SiteManagerInterface $site_manager
     */
    public function __construct(SiteInterface $site, User $user, Translator $translator, SiteManagerInterface $site_manager)
    {
        $this->site = $site;
        $this->user = $user;
        $this->translator = $translator;
        $this->site_manager = $site_manager;
    }

    /**
     * {@inheritdoc}
     */
    public function fill(AdminBar $admin_bar)
    {
        // Pongho
        $pongho = new Item('Pongho', pongho_url('/?site=' . $this->site->getId()));
        $pongho->addClass('pongho-admin-bar-logo');
        $admin_bar->left->add($pongho);

        $sites = $this->site_manager->findAll();

        if (is_pongho()) {
            // Sito / Multisito
            if (count($sites) === 1) {
                // Sito singolo
                if ($this->user->isFounder()) {
                    $admin_bar->left->add($this->getSitesSettingsItem());
                }
            } else {
                // Multisito
                $menu = new Menu($this->translator->trans('My sites'));
                foreach ($sites as $_site) {
                    $menu->add(new SiteMenu($_site, $this->translator));
                }

                if ($this->user->isFounder()) {
                    $menu->add($this->getSitesSettingsItem(), 999);
                }

                $admin_bar->left->add($menu);
            }

            // Home page
            $home = new Item($this->site->getName(), $this->site->getPermalink());
            $home->addClass('pongho-admin-bar-homepage');
            $admin_bar->left->add($home);
        } else {
            // Sito / Multisito
            if (count($sites) === 1) {
                // Sito singolo
                $menu = new SiteMenu($this->site, $this->translator);
                $menu
                    ->setLabel($this->translator->trans('Admin'))
                    ->setUrl(pongho_url('/?site=' . $this->site->getId()));
            } else {
                // Multisito
                $menu = new Menu($this->translator->trans('My sites'));
                foreach ($sites as $_site) {
                    $menu->add(new SiteMenu($_site, $this->translator));
                }
            }

            if ($this->user->isFounder()) {
                $sites_settings = new Item($this->translator->trans('Sites settings'), pongho_url('/sites/'));
                $sites_settings->addClass('pongho-admin-bar-sites-settings');
                $menu->add($sites_settings, 999);
            }

            $admin_bar->left->add($menu);
        }
    }

    /**
     * Restituisce la voce per la gestione siti.
     *
     * @return Item
     */
    protected function getSitesSettingsItem()
    {
        $sites_settings = new Item($this->translator->trans('Sites settings'), pongho_url('/sites/'));
        $sites_settings->addClass('pongho-admin-bar-sites-settings');

        return $sites_settings;
    }
}
