<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\AdminBar;

/**
 * AdminBarBuilder
 */
class AdminBarBuilder
{
    /**
     * @var AdminBar
     */
    protected $bar;

    /**
     * @var FillerInterface[]
     */
    protected $fillers = array();

    /**
     * @param AdminBar $bar
     */
    public function __construct(AdminBar $bar)
    {
        $this->bar = $bar;
    }

    /**
     * @param FillerInterface $filler
     * @return $this
     */
    public function add(FillerInterface $filler)
    {
        $this->fillers[] = $filler;

        return $this;
    }

    /**
     * @return AdminBar
     */
    public function build()
    {
        foreach ($this->fillers as $filler) {
            $filler->fill($this->bar);
        }

        return $this->bar;
    }
}
