<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widgets\Stats\View\GoogleChart;

use Application\Admin\Kernel;
use Pongho\Template\HeadHelper;

/**
 * GoogleChartFactory
 */
class ChartFactory
{
    /**
     * @var HeadHelper
     */
    protected $head;

    /**
     * @var bool
     */
    protected $prepared = false;

    public function __construct(HeadHelper $head)
    {
        $this->head = $head;
    }

    /**
     * @return Chart
     */
    public function createComboChart(array $header_labels = [], array $options = [])
    {
        $this->prepare();

        return new Chart('ComboChart', $header_labels, $options);
    }

    /**
     * @return Chart
     */
    public function createBarChart(array $header_labels = [], array $options = [])
    {
        $this->prepare();

        return new Chart('BarChart', $header_labels, $options);
    }

    protected function prepare()
    {
        if ($this->prepared) {
            return;
        }

        $this->head->addJavaScriptInline("window.google || document.write('<script src=\"//www.google.com/jsapi\">\\x3C/script>');");
        $this->head->addJavaScript(pongho_url('/Application/Admin/Resources/public/js/widget/graphs.js?v=' . Kernel::VERSION));

        $this->prepared = true;
    }
}
