<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widgets\Stats;

use Application\Admin\Widgets\WidgetInterface;
use Pongho\Http\Request;

class StatWidget implements WidgetInterface
{
    /**
     * @var string
     */
    protected $key;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var int
     */
    protected $columns;

    /**
     * @var ViewInterface
     */
    protected $view;

    /**
     * @var ReportInterface
     */
    protected $report;

    /**
     * @param string          $key
     * @param string          $title
     * @param int             $columns
     */
    public function __construct($key, $title, $columns, ViewInterface $view, ReportInterface $report)
    {
        $this->key = $key;
        $this->title = $title;
        $this->columns = $columns;
        $this->view = $view;
        $this->report = $report;
    }

    /**
     * {@inheritdoc}
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * {@inheritdoc}
     */
    public function getContent()
    {
        return $this->view->renderReport($this->report, $this->getKey());
    }

    /**
     * {@inheritdoc}
     */
    public function getColumns()
    {
        return $this->columns;
    }

    /**
     * {@inheritdoc}
     *
     * @codeCoverageIgnore Al momento i widget delle statistiche non hanno bisogno di fare richieste HTTP.
     */
    public function handleRequest(Request $request)
    {
        return null;
    }
}
