<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widgets;

use Application\Admin\Panels\PanelInterface;

class PanelWidgetsCollection implements PanelInterface
{
    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $key;

    /**
     * @var WidgetsCollection
     */
    protected $widgets;

    /**
     * @param string            $key
     * @param string            $title
     */
    public function __construct($key, $title, WidgetsCollection $widgets)
    {
        $this->key = $key;
        $this->title = $title;
        $this->widgets = $widgets;
    }

    /**
     * {@inheritdoc}
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * {@inheritdoc}
     */
    public function getContent()
    {
        return $this->widgets->render();
    }
}
