<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widget;

use Application\Core\Container;
use Pongho\Http\Exception\HttpNotFoundException;
use Pongho\Http\Request;

/**
 * Widget base per la dashboard.
 *
 * @deprecated Implementare direttamente WidgetInterface
 */
abstract class Widget implements WidgetInterface
{
    /**
     * Contenitore delle dipendenze.
     *
     * @var \Application\Core\Container
     */
    protected $container;

    /**
     * @param \Application\Core\Container $container
     */
    public function __construct(?Container $container = null)
    {
        $this->container = $container;
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->getName();
    }

    /**
     * {@inheritdoc}
     */
    public function getContent()
    {
        return $this->render();
    }

    /**
     * Restituisce il nome del Widget.
     *
     * Il nome viene utilizzato come titolo del widget all’interno della dashboard.
     *
     * @return string
     */
    abstract public function getName();

    /**
     * Restituisce quante colonne occupa il widget.
     *
     * @return integer Può essere 1 oppure 2.
     */
    abstract public function getColumns();

    /**
     * Restituisce il codice HTML per il rendering del widget.
     *
     * @return string
     */
    abstract public function render();

    /**
     * Imposta le intestazioni.
     *
     * @deprecated CSS e JS si possono essere impostati direttamente nel metodo render().
     */
    public function setHeaders()
    {
    }

    /**
     * Gestisce le richieste HTTP.
     *
     * Alcuni widget possono avere la necessità di poter gestire chiamate HTTP verso Pongho.
     *
     * L’URL della chiamata deve iniziare con ./pongho/widget/{widget-key}/ per arrivare a questo metodo.
     *
     * @throws \Pongho\Http\Exception\HttpNotFoundException
     * @return \Pongho\Http\Response
     */
    public function handleRequest(Request $request)
    {
        throw new HttpNotFoundException();
    }
}
