<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widget;

use Application\Admin\Widget\Stats\Collection;
use Application\Core\I18n\Translation\Translator;
use Pongho\EventDispatcher\Event;
use Pongho\EventDispatcher\EventDispatcher;

class StatsWidget implements WidgetInterface
{
    /**
     * @var Collection
     */
    private $collection;

    /**
     * @var Translator
     */
    private $translator;

    /**
     * @var EventDispatcher
     */
    private $dispatcher;

    public function __construct(Collection $collection, Translator $translator, EventDispatcher $dispatcher)
    {
        $this->collection = $collection;
        $this->translator = $translator;
        $this->dispatcher = $dispatcher;
    }

    /**
     * {@inheritdoc}
     */
    public function getKey()
    {
        return 'statsreport';
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->translator->trans('Pongho statistics');
    }

    /**
     * {@inheritdoc}
     */
    public function getColumns()
    {
        return 1;
    }

    /**
     * {@inheritdoc}
     */
    public function getContent()
    {
        /**
         * @deprecated Usare il servizio "admin_dashboard_stats_collection".
         */
        $event = new Event($this, 'admin.dashboard.widgets.filter_stats');
        $this->collection = $this->dispatcher->filter($event, $this->collection)->getReturnValue();

        $html = '';
        /** @var \Application\Admin\Widget\Stats\Stat $stat */
        foreach ($this->collection as $stat) {
            $html .= $stat->render();
        }

        return '<div id="statsreport-table">' . $html . '</div>';
    }
}
