<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widget\Stats;

class Stat implements StatInterface
{
    /**
     * @var string
     */
    protected $label;

    /**
     * @var string
     */
    protected $value;

    /**
     * @param string $label
     * @param string $value
     */
    public function __construct($label, $value)
    {
        $this->label = $label;
        $this->value = $value;
    }

    /**
     * {@inheritdoc}
     */
    public function render()
    {
        return <<<HTML
<table>
	<thead>
		<tr>
			<th>Tipo</th><th>Conteggio</th>
		</tr>
	</thead>
	<tr>
		<td>$this->label</td>
		<td>$this->value</td>
	</tr>
</table>
HTML;
    }
}
