<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widget\Stats;

class Collection implements \IteratorAggregate
{
    /**
     * @var StatInterface[]
     */
    protected $stats = [];

    public function add(StatInterface $stat)
    {
        $this->stats[] = $stat;
    }

    /**
     * {@inheritdoc}
     */
    public function getIterator(): \Traversable
    {
        return new \ArrayIterator($this->stats);
    }
}
