<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widget;

class PanelsCollection implements \IteratorAggregate
{
    /**
     * Elenco di widget.
     *
     * @var WidgetsCollection[]
     */
    protected $collection = [];

    /**
     * Permette di aggiungere un nuovo widget alla collezione.
     *
     * @param string            $name
     * @return $this La classe stessa.
     */
    public function add($name, WidgetsCollection $widgets)
    {
        $this->collection[$name] = $widgets;

        return $this;
    }

    /**
     * Restituisce un widget in base alla chiave passata.
     *
     * @param string $name
     * @throws \InvalidArgumentException Se il pannello richiesto non esiste.
     * @return WidgetsCollection
     */
    public function get($name)
    {
        if (!array_key_exists($name, $this->collection)) {
            throw new \InvalidArgumentException(sprintf('Panel "%s" not exists!', $name));
        }

        return $this->collection[$name];
    }

    /**
     * Indica se esiste un widget con la chiave passata.
     *
     * @param string $name
     * @return boolean
     */
    public function has($name)
    {
        return array_key_exists($name, $this->collection);
    }

    /**
     * Implementa l’interfaccia IteratorAggregate.
     *
     * @return \ArrayIterator
     */
    public function getIterator(): \Traversable
    {
        return new \ArrayIterator($this->collection);
    }
}
