<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widget\Charts;

use Application\Admin\Widget\Widget;
use Application\Core\Container;

abstract class BaseChartWidget extends Widget
{
    /**
     * @var string
     */
    protected $key;

    /**
     * @var int
     */
    protected $columns = 2;

    /**
     * @param string    $key
     */
    public function __construct(Container $container, $key)
    {
        $this->key = $key;
        $this->container = $container;
    }

    /**
     * {@inheritdoc}
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * {@inheritdoc}
     */
    public function render()
    {
        return '';
    }

    /**
     * @return \Application\Core\Localization
     *
     * @deprecated
     */
    protected function getLocalization()
    {
        return $this->container->get('language');
    }

    /**
     * {@inheritdoc}
     *
     * @todo spostare nei singoli widget in modo da poter usare il Translator
     */
    public function getName()
    {
        /** @var \Application\Core\Localization $lang */
        $lang = $this->container->get('language');

        return $lang->get('chart_' . $this->getKey());
    }

    /**
     * Imposta la larghezza del widget in colonne (1 o 2)
     *
     * @param $columns
     */
    public function setColumns($columns)
    {
        $this->columns = $columns;
    }

    /**
     * {@inheritdoc}
     */
    public function getColumns()
    {
        return $this->columns;
    }

    /**
     * Restituisce la configurazione e i dati per il widget del grafico di Google Charts
     *
     * @return array
     */
    public function getData()
    {
        return [
            'report' => $this->getReport(),
            'chart'  => $this->getChartType(),
            'opts'   => $this->getChartOptions(),
        ];
    }

    /**
     * Restituisce il tipo di grafico Google Charts
     *
     * @return string
     */
    abstract protected function getChartType();

    /**
     * Restituisce le opzioni di configurazione per il grafico
     *
     * @return array
     */
    abstract protected function getChartOptions();

    /**
     * Restituisce i dati del grafico
     *
     * @return array
     */
    abstract protected function getReport();
}
