<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Utilities;

use Application\Admin\AdminBar\AdminBarRenderer;
use Pongho\Core\TemplateResponse;

class HttpNotFoundResponseFactory
{
    /**
     * @var AdminControllerHelper
     */
    protected $helper;

    /**
     * @var AdminBarRenderer
     */
    protected $renderer;

    public function __construct(AdminControllerHelper $helper, AdminBarRenderer $renderer)
    {
        $this->helper = $helper;
        $this->renderer = $renderer;
    }

    /**
     * @return TemplateResponse
     */
    public function getResponse()
    {
        $view = $this->helper->getBodyView();
        $view->setTemplatePath(PONGHO_PATH . '/Application/Admin/Resources/views/404.php');

        $response = new TemplateResponse($this->helper->getView());

        return $this->renderer->render($response);
    }
}
