<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Utilities;

class FilterOperators
{
    /**
     * @var array
     */
    protected $operators;

    /**
     * Restituisce gli operatori
     *
     * @return array
     */
    public function getOperators()
    {
        return $this->operators;
    }

    /**
     * @param string $type
     * @return bool
     */
    public function hasOperator($type)
    {
        return array_key_exists($type, $this->operators);
    }

    /**
     * Aggiunge un nuovo tipo di operatore se non è già presente
     *
     * @param string $type
     */
    public function addOperator($type, array $operator)
    {
        if (!$this->hasOperator($type)) {
            $this->setOperator($type, $operator);
        }
    }

    /**
     * Rimuove un tipo di operatore
     *
     * @param string $type
     */
    public function removeOperator($type)
    {
        unset($this->operators[$type]);
    }

    /**
     * Inserisce un nuovo tipo di operatore o ne sovrascrive uno già presente
     *
     * @param string $type
     */
    public function setOperator($type, array $operator)
    {
        $this->operators[$type] = $operator;
    }
}
