<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Utilities;

use Application\Core\Model\LanguageSite;
use Application\Core\Model\Site;
use Pongho\Http\Request;

/**
 * Class ContentLanguage
 *
 * Restituisce la lingua per l'interfaccia
 */
class ContentLanguage
{
    /**
     * @var \Application\Core\Model\Site
     */
    protected $site;

    /**
     * @var \Pongho\Http\Request
     */
    protected $request;

    public function __construct(Site $site, Request $request)
    {
        $this->site = $site;
        $this->request = $request;
    }

    /** @var int */
    protected $content_language;

    /**
     * Restituisce la lingua per l'interfaccia
     *
     * @return int
     */
    public function getId()
    {
        if ($this->content_language === null) {
            $this->content_language = $this->request->query->has('language') ? intval($this->request->query->get('language')) : $this->site->default_language_id;

            // Verifico che la lingua sia abilitata per il sito corrente
            if (LanguageSite::findByLanguageAndSite($this->content_language, $this->site->id) === null) {
                $this->content_language = $this->site->default_language_id;
            }
        }

        return $this->content_language;
    }
}
