<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Utilities;

/**
 * Interface ArchiveInterface
 */
interface ArchiveInterface
{
    /**
     * Restituisce i record del modello filtrati.
     *
     * @return \ActiveRecord\Base[]
     */
    public function getRecords($page = null);

    /**
     * Restituisce il numero totale di record disponibili.
     *
     * @return int
     */
    public function getTotalRecords();

    /**
     * Restituisce la paginazione.
     *
     * @return \Application\Core\Utilities\Pagination
     */
    public function getPagination();

    /**
     * @throws \LogicException
     * @return string
     */
    public function getTable();

    public function setFilters(array $filters);

    /**
     * Restituisce i filtri rapidi.
     *
     * @return \Pongho\Menu\Menu
     */
    public function getFastFilters();

    /**
     * Imposta le opzioni per la query dei filtri rapidi, nel caso serva personalizzarla rispetto a quella del modello di default
     *
     * @param $options
     */
    public function setFastFilterQuery($options);

    /**
     * Indica se i filtri sono abilitati.
     *
     * @return bool
     */
    public function isFiltersEnabled();

    /**
     * Indica se i filtri rapidi sono abilitati.
     *
     * @return bool
     */
    public function isFastFiltersEnabled();

    /**
     * Indica se la ricerca è abilitata.
     *
     * @return bool
     */
    public function isSearchEnabled();
}
