<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Updates;

use Application\Admin\Model\AdminModule;
use Application\Core\Model\Translation;
use Updates\BaseUpdate;

class Update89 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $settings_panel = AdminModule::findPanel('settings');
        if ($settings_panel && !AdminModule::findByName('apps')) {
            AdminModule::create([
                'parent_id'  => $settings_panel->id,
                'position'   => 50,
                'name'       => 'apps',
                'path'       => 'apps',
                'controller' => \Application\Core\Controller\Admin\AppsController::class,
            ]);
        }

        Translation::putTranslation('modules_apps', 'Gestione applicazioni', 'admin', 'it_IT');
        Translation::putTranslation('apps_settings', 'Gestione applicazioni', 'admin', 'it_IT');
        Translation::putTranslation('app_name', 'Applicazione', 'admin', 'it_IT');
        Translation::putTranslation('app_version', 'Versione', 'admin', 'it_IT');

        Translation::putTranslation('uninstall', 'Disinstalla', 'admin', 'it_IT');
        Translation::changeApplication('install', 'admin');
        Translation::changeApplication('installed', 'admin');
    }
}
