<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Updates;

use Application\Core\Model\Account;
use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update71 extends SchemaUpdate
{
    protected function prepareSchema(Schema $schema)
    {
        $table = $schema->getTable('pongho_filters');
        $table->addColumn('user_id', 'integer', ['unsigned' => true, 'notnull' => false, 'default' => Account::ANONYMOUS]);
        $table->addForeignKeyConstraint($schema->getTable('pongho_users'), ['user_id'], ['id']);
    }
}
