<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

/**
 * Class Update161
 *
 * Aggiunge la tabella per la gestione dell'ultimo record visualizzato nei CRUD
 */
class Update161 extends SchemaUpdate
{
    protected function prepareSchema(Schema $schema)
    {
        $table = $schema->createTable('pongho_archive_last_views');
        $table->addColumn('user_id', 'integer', ['unsigned' => true]);
        $table->addColumn('entity_type', 'string', ['length' => 255]);
        $table->addColumn('entity_id', 'integer', ['unsigned' => true]);
        $table->addColumn('updated_at', 'datetime');
        $table->setPrimaryKey(['user_id', 'entity_type']);
        $table->addForeignKeyConstraint($schema->getTable('pongho_users'), ['user_id'], ['id'], ['onDelete' => 'CASCADE']);
    }
}
