<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Widgets\Stats\View\GoogleChart;

function pongho_url($url)
{
    return $url;
}

namespace Application\Admin\Tests\Widgets\Stats\View\GoogleChart;

use Application\Admin\Widgets\Stats\View\GoogleChart\Chart;
use Application\Admin\Widgets\Stats\View\GoogleChart\ChartFactory;
use PHPUnit\Framework\MockObject\MockObject;
use Pongho\Template\HeadHelper;

class ChartFactoryTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @dataProvider chartTypeProvider
     * @param string $method
     * @param string $type
     */
    public function testChartType($method, $type): void
    {
        $head = $this->getHeadHelperMock();

        $factory = new ChartFactory($head);
        $chart = call_user_func([$factory, $method], [], []);

        $this->assertInstanceOf(Chart::class, $chart);
        $this->assertEquals($type, $chart->getType());
    }

    public function chartTypeProvider()
    {
        return [
            ['createComboChart', 'ComboChart'],
            ['createBarChart', 'BarChart'],
        ];
    }

    public function testCreateManyChartLoadJsOnlyOnce(): void
    {
        $head = $this->getHeadHelperMock();
        $head->expects($this->once())->method('addJavaScript');
        $head->expects($this->once())->method('addJavaScriptInline');

        $factory = new ChartFactory($head);

        $factory->createBarChart([], []);
        $factory->createComboChart([], []);
    }

    private function getHeadHelperMock(): HeadHelper|MockObject
    {
        return $this->getMockBuilder(HeadHelper::class)
            ->disableOriginalConstructor()
            ->setMethods(['addJavaScript', 'addJavaScriptInline'])
            ->getMock();
    }
}
