<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Tests\Widgets\Stats;

use Application\Admin\Widgets\Stats\ReportInterface;
use Application\Admin\Widgets\Stats\StatWidget;
use Application\Admin\Widgets\Stats\ViewInterface;
use Application\Admin\Widgets\WidgetInterface;
use PHPUnit\Framework\MockObject\MockObject;

class StatWidgetTest extends \PHPUnit\Framework\TestCase
{
    public function testWidget(): void
    {
        $report = $this->getReportMock();
        $view = $this->getViewMock($report);

        $widget = new StatWidget('foo', 'Foo Widget Title', 2, $view, $report);

        $this->assertInstanceOf(WidgetInterface::class, $widget);

        $this->assertEquals('foo', $widget->getKey());
        $this->assertEquals('Foo Widget Title', $widget->getTitle());
        $this->assertEquals(2, $widget->getColumns());
        $this->assertEquals('Foo Report Content', $widget->getContent());
    }

    private function getReportMock(): ReportInterface|MockObject
    {
        return $this->createMock(ReportInterface::class);
    }

    private function getViewMock(ReportInterface $report): ViewInterface|MockObject
    {
        $view = $this->createMock(ViewInterface::class);
        $view->expects($this->once())->method('renderReport')->with($report, 'foo')->willReturn('Foo Report Content');

        return $view;
    }
}
