<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Tests\Widgets;

use Application\Admin\Widgets\PanelWidgetsCollection;
use Application\Admin\Widgets\WidgetsCollection;
use PHPUnit\Framework\MockObject\MockObject;

class PanelWidgetsCollectionTest extends \PHPUnit\Framework\TestCase
{
    public function testPanel(): void
    {
        $panel = new PanelWidgetsCollection('foo', 'Foo Title', $this->getWidgetsCollectionMock());

        $this->assertEquals('foo', $panel->getKey());
        $this->assertEquals('Foo Title', $panel->getTitle());
        $panel->getContent();
    }

    private function getWidgetsCollectionMock(): WidgetsCollection|MockObject
    {
        $coll = $this->createMock(WidgetsCollection::class);

        $coll->expects($this->once())->method('render');

        return $coll;
    }
}
