<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

/*
 * Mock della funzione pongho_url usata da \Application\Admin\Utilities\PonghoUrl
 * La funzione pongho_url utilizza il Kernel, perciò non può essere utilizzata nel test
 */
namespace Application\Admin\Utilities;

function pongho_url($url)
{
    return $url;
}

namespace Application\Admin\Tests\PonghoUrl;

use Application\Admin\Utilities\ContentLanguage;
use Application\Admin\Utilities\PonghoUrl;
use Application\Core\Model\Site;
use PHPUnit\Framework\MockObject\MockObject;
use Pongho\Http\Request;

class PonghoUrlTest extends \PHPUnit\Framework\TestCase
{
    public function testUrl(): void
    {
        $pongho_url = new PonghoUrl(
            $this->getSiteMock(123),
            $this->getRequestMock('/'),
            $this->getContentLanguageMock(321)
        );

        $url = $pongho_url->url('/path/', '&');
        $parse = parse_url($url, PHP_URL_QUERY);
        $query = [];
        parse_str($parse, $query);

        $this->assertEquals('/path/', parse_url($url, PHP_URL_PATH));
        $this->assertEquals(123, $query['site']);
        $this->assertEquals(321, $query['language']);
    }

    public function testCurrentUrl(): void
    {
        $pongho_url = new PonghoUrl(
            $this->getSiteMock(1),
            $this->getRequestMock('/pongho/current/'),
            $this->getContentLanguageMock(1)
        );

        $this->assertEquals('/current/', parse_url($pongho_url->currentUrl('&'), PHP_URL_PATH));
    }

    /**
     * @param $site_id
     */
    protected function getSiteMock($site_id, $domain = null): Site|MockObject
    {
        $site = $this->createMock(Site::class);

        $site->expects($this->any())
            ->method('domain')
            ->will($this->returnValue($domain));

        $site->expects($this->any())
            ->method('getId')
            ->will($this->returnValue($site_id));

        return $site;
    }

    /**
     * @param $uri
     * @return Request
     */
    protected function getRequestMock($uri)
    {
        return Request::create($uri);
    }

    /**
     * @param $language_id
     */
    protected function getContentLanguageMock($language_id): ContentLanguage|MockObject
    {
        $content_language = $this->createMock(ContentLanguage::class);

        $content_language->expects($this->any())
            ->method('getId')
            ->will($this->returnValue($language_id));

        return $content_language;
    }
}
