<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Tests\AdminBar;

use Application\Admin\AdminBar\AdminBarRenderer;
use Pongho\Core\TemplateResponse;

class AdminBarRendererTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @dataProvider viewProvider
     */
    public function testRenderer($original, $expected): void
    {
        /**
         * @var \Application\Admin\AdminBar\AdminBar        $bar
         * @var \Application\Admin\AdminBar\AdminBarBuilder $builder
         * @var \Pongho\Template\ViewInterface              $view
         */
        $bar = $this->createMock(\Application\Admin\AdminBar\AdminBar::class);
        $bar->expects($this->any())
            ->method('render')
            ->will($this->returnValue('<code>ADMIN BAR</code>'));

        $builder = $this->createMock(\Application\Admin\AdminBar\AdminBarBuilder::class);

        $builder->expects($this->once())
            ->method('build')
            ->will($this->returnValue($bar));

        $view = $this->createMock(\Pongho\Template\ViewInterface::class);
        $view->expects($this->once())
            ->method('render')
            ->will($this->returnValue($original));

        $response = new TemplateResponse($view);
        $renderer = new AdminBarRenderer($builder);

        $this->assertEquals($expected, $renderer->render($response)->getContent());
    }

    public function viewProvider()
    {
        return [
            [
                <<<HTML
<html>
<head></head>
<body>
<div>PAGE CONTENT</div>
</body>
</html>
HTML,
                <<<HTML
<html>
<head></head>
<body><code>ADMIN BAR</code>
<div>PAGE CONTENT</div>
</body>
</html>
HTML,
            ],
            [
                <<<HTML
<html>
<head></head>
<body class="body" id="body">
<div>PAGE CONTENT</div>
</body>
</html>
HTML,
                <<<HTML
<html>
<head></head>
<body class="body" id="body"><code>ADMIN BAR</code>
<div>PAGE CONTENT</div>
</body>
</html>
HTML,
            ],
        ];
    }
}
