<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Routes;

use Application\Admin\AdminSidebar\Sidebar;
use Application\Admin\Utilities\HttpNotFoundResponseFactory;
use Application\Admin\Utilities\PonghoUrl;
use Application\Core\Model\Site;
use Application\Core\User;
use Pongho\Http\RedirectResponse;
use Pongho\Http\Request;
use Pongho\Routing\RouteInterface;

class PonghoRoute implements RouteInterface
{
    /**
     * @var Sidebar
     */
    protected $sidebar;

    /**
     * @var User
     */
    protected $user;

    /**
     * @var Site
     */
    protected $site;

    /**
     * @var PonghoUrl
     */
    protected $pongho_url;

    /**
     * Nome del controller.
     *
     * @var string
     */
    protected $controller;

    /**
     * Azione.
     *
     * @var string
     */
    protected $action = 'index';

    /**
     * Parametri.
     *
     * @var array
     */
    protected $parameters = [];

    /**
     * @var HttpNotFoundResponseFactory
     */
    protected $not_found_response_factory;

    public function __construct(Sidebar $sidebar, User $user, Site $main_site, PonghoUrl $pongho_url, HttpNotFoundResponseFactory $not_found_response_factory)
    {
        $this->sidebar = $sidebar;
        $this->user = $user;
        $this->site = $main_site;
        $this->pongho_url = $pongho_url;
        $this->not_found_response_factory = $not_found_response_factory;
    }

    /**
     * {@inheritdoc}
     */
    public function match(Request $request)
    {
        $path_info = $request->getPathInfo();

        if (!str_starts_with($path_info, '/pongho/')) {
            return false;
        }

        if (!$this->user->isLogged()) {
            $qs = http_build_query(['redirect' => $this->pongho_url->currentUrl('&')], '', '&');
            $login_url = $this->site->getDomain() . '/user/login/?' . $qs;

            return new RedirectResponse($login_url);
        }

        $path_info = substr($request->getPathInfo(), 8);

        // Moduli
        $item = $this->sidebar->getActiveItem();

        if (!$item) {
            return $this->not_found_response_factory->getResponse();
        }

        $this->controller = $item->getController();
        $this->parameters['module_id'] = $item->getModuleId();

        $segments = explode('/', trim($item->getPath(), '/'));
        $this->parameters['path'] = $segments[0] ?? '';

        // Dashboard
        if ($path_info !== '') {
            $segments = explode('/', trim($path_info, '/'));

            if (isset($segments[1])) {
                $this->action = $segments[1];

                if ($this->action === 'page') {
                    if (isset($segments[2]) && is_numeric($segments[2])) {
                        $this->parameters['page'] = intval($segments[2]);
                    } else {
                        return false;
                    }
                } elseif (isset($segments[2]) && is_numeric($segments[2])) {
                    $this->parameters['id'] = intval($segments[2]);
                }
            }
        }

        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function getController()
    {
        return $this->controller;
    }

    /**
     * {@inheritdoc}
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * {@inheritdoc}
     */
    public function getParameters()
    {
        return $this->parameters;
    }
}
