/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */
/*global $, jQuery, Pongho, wysiwygOptions */

(function ($) {
    "use strict";

    /**
     * Applica i plugin ai campi gestiti da javascript (come wysiwyg, colorpicker, chosone, etc).
     *
     * @param el Elemento DOM nel quale cercare i campi.
     */
    function parseFields(el) {
        if (Pongho && Pongho.wysiwyg) {
            Pongho.wysiwyg.attach(el);
        }

        el.find('.colorpicker').attachColorpicker();
        el.find('.link-type-wrapper').newLinkType();
        el.find('.autosuggest').autosuggest();
        el.find('.js-select').chosen();

        el.find('.preview').colorbox({
            maxWidth: '90%',
            maxHeight: '90%',
            scalePhotos: true
        });
    }

    /**
     * Prepara il javascript al caricamento di un nuovo pannello.
     *
     * @param el
     */
    function onCreatePanel(el) {
        el.find('.repeater').repeater();
        el.find('.tabs').newTabs();
        el.find('.panel-accordion').panelAccordion();

        parseFields(el);

        $('.repeater')
            .on('row_add', function (event, row) {
                parseFields(row);
            })
            .on('sortstart', function (event, ui) {
                if (Pongho && Pongho.wysiwyg) {
                    Pongho.wysiwyg.detach(ui.item);
                }
            })
            .on('sortstop', function (event, ui) {
                if (Pongho && Pongho.wysiwyg) {
                    Pongho.wysiwyg.attach(ui.item);
                }
            });
    }

    var tabsPanel = $('.form-wrapper');

    if (Pongho.action !== 'add') {
        tabsPanel.ajaxForm().on('after-update', function () {
            onCreatePanel($(this));
        });
    }

    // Aggiungo la classe loading a tutti i button che effettuano il submit per indicare che sto facendo un'azione
    // La classe viene rimossa quando viene ricaricato il template, non serve rimuoverla manualmente
    tabsPanel.on('submit', 'form', function () {
        $(this).find('button[type="submit"]').addClass('busy');
    });

    onCreatePanel(tabsPanel);

}(jQuery));
