/**
 * Plugin di jQuery per l’area amministrativa di Pongho
 */

(function($){

	/**
	 * Tabs
	 *
	 * @author Daniele De Nobili
	 * @copyright 2010 Daniele De Nobili
	 */
	$.fn.tabs = function(){
		return this.each(function(){
			var that = $(this),
				a = that.find("li.active a"),
				t = a.length ? a : $("li:first-child", that);

			loader(t);

			$("a", that).click(function(event){
				event.preventDefault();
				t = $(this);
				loader(t);
				t.parent().siblings().removeClass("active");
				t.parent().addClass("active");
			});
		});

		function loader(e){
			var h = e.attr('href') + '',
				ul = e.parent().parent();

			// Tento di risolvere un bug di IE
			if ( h.indexOf('#',0) != -1 ) {
				// Se trovo il simbolo di cancelletto (#) nel tag href
				h = /#.*/.exec(h) + '';
			}

			ul.nextAll(".tabsPanel").hide();
			if ( h.substr(0,1) === "#" ){
				$(h).show();
			} else {
				ul.parent().find(".tabsPanel.ajax").empty().show().addClass("loading").load(h, function(){
					$(this).removeClass("loading");
				});
			}
		}
	};

	/**
	 * Accordion
	 *
	 * @author Daniele De Nobili
	 * @copyright 2010 Daniele De Nobili
	 */
	$.fn.accordion = function(opts){
		var o = $.extend({}, {
				top		: '.top'
			}, opts);

		return $(this).each(function(){
			$(o.top, $(this)).each(function(){
				var t = $(this), s = t.next(), p = t.parent();

				if (s.length)
				{
					p.addClass("open");
					t.css("cursor","pointer").append('<span class="toggle"/>').click(function(){
						if ( p.hasClass("open") ){
							s.slideUp("fast", function(){
								p.removeClass("open");
							});
						} else {
							s.slideDown("fast", function(){
								p.addClass("open");
							});
						}
					});
				}
			});
		});
	};

	/**
	 * Formalize
	 *
	 * Elabora il modulo per prelevare i valori dei campi.
	 * Il risultato è un oggetto le cui proprietà rappresentano il nome/valore dei campi.
	 *
	 * Esempio:
	 *   var foo = $("form").formalize();
	 *   username = foo.username;
	 *   password = foo.password;
	 *
	 * @author Daniele De Nobili
	 * @copyright 2010 Daniele De Nobili
	 */
	$.fn.formalize = function(){
		var e = {};
		$("input:file,input:hidden,input:radio:checked,input:password,input:submit,input:text,select,textarea,button",this).each(function(){
			e[this.name] = $(this).val();
		});
		$("input:checkbox",this).each(function(){
			if ( this.checked ) e[this.name] = true;
		});
		return e;
	};

	/**
	 * Box
	 *
	 * Visualizza un messaggio.
	 *
	 * @param txt string	: Testo del messaggio
	 * @param c string		: Classe
	 * @param e jquery		: Elemento prima del quale verrà inserito il box
	 *
	 * @author Daniele De Nobili
	 * @copyright 2010 Daniele De Nobili
	 */
	$.fn.box = function( txt, c, e ){
		var box = $("#box-message"),
			open = box.length;

		if (open) {
			box.fadeOut();
		} else {
			box = $('<div id="box-message" class="box '+c+'" />').hide();
			box.insertBefore( e );
		}

		box.removeClass('error info alert').addClass( c ).html( txt ).fadeIn();
	};

	/**
	 * ShowPass
	 *
	 * Permette di visualizzare (e nascondere) la password che si sta digitando.
	 */
	$.fn.showpass = function(opts) {
		var o = $.extend({}, {
				show	: 'Show password',
				hide	: 'Hide password',
				classname	: 'showpass',
				elem	: '<span />'
			}, opts);

		return this.each(function(){
			var that = $(this),
				a = $(o.elem),
				b = $('<input type="text" />');

			b.css("display", "inline").addClass(that.attr('class')).hide();
			a.data('show',false).text(o.show).addClass(o.classname).click(function(){
				if (a.data('show')){
					a.data('show',false).text(o.show);
					b.hide();
					that.val(b.val()).show();
				} else {
					a.data('show',true).text(o.hide);
					that.hide();
					b.val(that.val()).show();
				}
			});

			that.after(a).after(b);

			that.parents('form').submit(function(){
				if (a.data('show')) that.val(b.val());
			});
		});
	};

	/**
	 * tableManager
	 *
	 * Gestisce le tabelle:
	 * - Aggiunge la classe 'odd' alle righe dispari delle tabelle.
	 * - Permette l'hover sulle righe per visualizzare le azioni.
	 * - Gestisce il comportamento dei checkbox nei capicolonna.
	 * - Elimina la riga quando si utilizza il comando di eliminazione.
	 * - Aggiugere una riga in fondo alla tabella quando si clicca sul pulsante per
	 *   aggiungere un nuovo record.
	 *
	 * Tutte le feature sono automatiche, tranne l’ultima che si attiva solo se nella
	 * tabella è presente una riga <tr> con classe "blank_entry".
	 */
	$.fn.tableManager = function(l){

		l = $.extend({}, {
            delete_row : 'Sei sicuro di voler cancellare “{name}”?'
        }, l);

		return this.each(function(){
			var table = $(this),
				blankRecord = $("tr.blankRecord", table),
				counter = $("tr:visible", table).length;

			checkboxManager();
			deleteManager();
			approveManager();

			if (blankRecord.length){
				blankRecord = blankRecord.clone();
				addRecordManager();
			}

			// Gestione dei checkbox nei capicolonna
			function checkboxManager(){
				$("th input:checkbox", table).click(function(){
					var ckb = $(".ckb input:checkbox", $(this).parents("table"));
					this.checked ? ckb.attr('checked', 'checked') : ckb.removeAttr('checked');
				});
			}

			// Elimina record
			function deleteManager(){
				$(".delete", table).click(function(){
					var t = $(this),
						row = t.parents("tr"),
                        message = t.data('confirm-message') || l.delete_row.replace('{name}', $(".main strong", row).text());

					// Chiedo conferma dell’eliminazione
					if (confirm(message)){
						$.post(this.href, {'confirm': 1}, function(d){
							if (d.error){
								alert(d.message);
							} else {
								var tbody = row.closest('tbody'), colspan = countColspanInRow(row);
								row.fadeOut(500, function(){
									row.remove();
									if ($("tr", tbody).length == 0){
										tbody.html('<tr><td colspan="'+colspan+'" class="empty">&nbsp;</td></tr>');
									}
								});
							}
						}, 'json');
					}

					return false;
				});
			}

			// Approva record
			function approveManager(){
				$(".approve", table).click(function(){
					var t = $(this);

					$.post(this.href, {}, function(d){
						if (d.errno){
							alert(d.errmsg);
						} else {
							t.remove();
						}
					}, 'json');

					return false;
				});
			}

			// Aggiungi nuovo record
			function addRecordManager()
			{
				// Il pulsante e la tabella sono relazionate fra di loro
				// in quanto all’interno dello stesso <fieldset>.
				var addRecord = $("input.addRecord", table.closest("fieldset"));

				addRecord.bind("click", function(){
					var newRecord = blankRecord.clone();

					// Aggiorno l’id delle input della riga
					$("input,select,textarea", newRecord).each(function() {
                        var el = this;
                        el.name = el.name.replace('[new]', '[new_'+counter+']');
					});
					counter++;

					newRecord.removeClass("blankRecord hide").show().appendTo($("tbody", table));
				});
			}

			function countColspanInRow(row){
				var colspan = 0;
				$("td", row).each(function(){
					colspan += $(this).attr("colspan");
				});

				return colspan;
			}

			// Disabilito il tasto INVIO se ho il focus nelle checkbox della tabella
			table.find('.ckb input:checkbox').on('kedown keypress keyup', function (e) {
				e.preventDefault();
			});
		});

	};

	/**
	 * Multi Upload Manager
	 *
	 * Gestisce i campi di upload multipli, come le immagini per i prodotti, gli allegati
	 * per le newsletter, etc...
	 * Viene normalmente applicato ad una lista di definizione `<dl />` con una struttura simile
	 * a questa:
	 *
	 *   <dl>
	 *     <dt />
	 *     <dd>
	 *       <input type="file" />
	 *       <a class="delete" style="display: none;" />
	 *     </dd>
	 *     <dd>
	 *       <input type="button" class="addRow" />
	 *     </dd>
	 *   </dl>
	 *
	 * Il plugin non dovrebbe avere problemi nel caso vengano aggiunti dei wrapper o ulteriori
	 * elementi di definizione <dd />, purché venga rispettata la struttura.
	 */
	$.fn.multiUploadManager = function(opts) {
		var o = $.extend({}, {
			confirm_message:	"Stai per eliminare il file!",
			max_files:			0
		}, opts);

		return this.each(function() {
			var t = $(this),

				// Riga clone
				c = $("input[type=file]:first", t).closest("dd").clone();

			manageAddLink();

			// Svuota il valore della input nella riga clone
			c.find("input").val(null);

			// Evento click sul pulsante per aggiungere un nuovo campo file
			$(".add-row", t).bind("click", function(){
				c.clone().insertAfter($("input[type=file]:last", t).closest("dd"));
				manageDelLinks();
				manageAddLink();
			});

			// Evento click sui pulsanti per eliminare il campo file corrispettivo
			t.on('click', 'a.delete', function (event) {
				var del = $(this),
					row = del.closest('dd'),
					href = del.attr('href');

				if (typeof href !== 'undefined' && href !== false && confirm(o.confirm_message)) {
					$.get(this.href, function (data) {
						if (data.error) {
							alert(data.message);
						} else {
							row.fadeOut(function () {
								row.remove();
							});
						}
					}, 'json');
				} else {
					row.remove();
				}

				manageDelLinks();
				manageAddLink();

				event.preventDefault();
			});

			// Gestisce la visualizzazione dei link per l’eliminazione delle righe
			function manageDelLinks(){
				var d = getDelLinks();
				d.length > 1 ? d.show() : d.hide();
			}

			// Resituisce i link di eliminazione delle righe
			function getDelLinks(){
				return $("input[type=file]", t).closest("dd").find(".delete");
			}

			// Gestisce la visualizzazione del pulsante per aggiungere nuove righe
			function manageAddLink() {
				if (o.max_files == 0) {
					return;
				}

				var uploaded_rows_length = $(".uploaded-row", t).length,
					input_rows = $("input[type=file]", t).closest("dd"),
					input_rows_length = input_rows.length,
					add_row = $(".add-row", t).closest("dd");

				if (uploaded_rows_length + input_rows_length < o.max_files) {
					input_rows.show();
					add_row.show();
				} else if (uploaded_rows_length < o.max_files) {
					input_rows.show();
					add_row.hide();
				} else {
					input_rows.hide();
					add_row.hide();
				}

//				if (!isPermit()){
//					$(".add-row", t).closest("dd").hide();
//				} else {
//					$(".add-row", t).closest("dd").show();
//				}
			}

//			// Restituisce true se posso aggiungere altri campi
//			function isPermit(){
//				return o.max_files ? (countFiles() < o.max_files) : true;
//			}
//
//			// Restituisce il numero di campi file presenti
//			function countFiles(){
//				return $(".uploaded-row", t).length + $("input[type=file]", t).length - 1;
//			}
		});
	};
})(jQuery);
