/**
 * JS per il widget PageviewsReport.
 *
 * @author Daniele De Nobili
 * @copyright (c) Web Agency Meta Line - metaline.it
 */

/*jslint plusplus: true, browser: true, indent: 4, unparam: true */


// Controllo delle dipendenze
if (window.jQuery === undefined) {
	throw 'jQuery not loaded!';
}

if (window.widget === undefined || window.widget.pageviewsreport === undefined) {
	throw 'Options not defined!';
}

(function ($, google, o) {
	'use strict';

	var content = $('#pageviewsreport-table');

	$.getJSON(o.url, function (response) {
		content.removeClass('loading');

		if (response.error) {
			content.addClass('alert').text(response.error);

			return;
		}

		content.html(response.code);
	});
}(window.jQuery, window.google, window.widget.pageviewsreport));
