/**
 * JS per il widget VisitsReport.
 *
 * @author Daniele De Nobili
 */

/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */
/*global $, google */

var Pongho = window.Pongho || {};

Pongho.GoogleChart = function () {
    "use strict";

    var data = Pongho.widgets || {};

    function Chart(key, content) {
        this.key = key;

        this.table = google.visualization.arrayToDataTable(data[this.key].report);
        this.chart = new google.visualization[data[this.key].chart](content);
    }

    Chart.prototype.draw = function () {
        var opts = $.extend({}, {
            width: '100%',
            height: 300,
            pointSize: 5
        }, data[this.key].opts);

        this.chart.draw(this.table, opts);
    };

    $('.widget').each(function () {
        var $widget = $(this),
            key = $widget.data('key'),
            chart;

        if (data[key]) {
            chart = new Chart(key, $widget.find('.widget-content').get(0));
            chart.draw();

            $(window).on('resize', function () {
                chart.draw();
            });
        }
    });
};

google.load('visualization', '1.0', {'packages': ['corechart']});
google.setOnLoadCallback(Pongho.GoogleChart);
