<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Panels;

class Panel implements PanelInterface
{
    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $key;

    /**
     * @var string
     */
    protected $content;

    /**
     * @param string $key
     * @param string $name
     * @param string $content
     */
    public function __construct($key, $name, $content)
    {
        $this->key = $key;
        $this->title = $name;
        $this->content = $content;
    }

    /**
     * {@inheritdoc}
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * {@inheritdoc}
     */
    public function getContent()
    {
        return $this->content;
    }
}
