<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Model;

use ActiveRecord\Base;

/**
 * @property int                        $user_id
 * @property string                     $entity_type
 * @property int                        $entity_id
 * @property \Pongho\Utilities\DateTime $updated_at
 */
class ArchiveLastView extends Base
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'archive_last_views';

    /**
     * Chiave primaria.
     *
     * @var array
     */
    public static $primary_key = ['user_id', 'entity_type'];

    /**
     * @return int
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * @return string
     */
    public function getEntityType()
    {
        return $this->entity_type;
    }

    /**
     * @return int
     */
    public function getEntityId()
    {
        return $this->entity_id;
    }

    /**
     * @param int $entity_id
     */
    public function setEntityId($entity_id)
    {
        $this->entity_id = intval($entity_id);
    }

    /**
     * @return \Pongho\Utilities\DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updated_at;
    }
}
