<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Form;

use Pongho\Form\Subject\SubjectInterface;

/**
 * TranslatableInterface.
 */
interface TranslatableInterface
{
    /**
     * Restituisce il tipo di modello che deve gestire la traduzione
     *
     * @return string
     */
    public function getEntityType();

    /**
     * Restituisce le traduzioni del modello.
     *
     * @param bool $only_enabled
     * @return SubjectInterface[]
     */
    public function getTranslations($only_enabled = true);

    /**
     * Restituisce la traduzione del modello nella lingua specificata.
     *
     * @param integer $language_id
     * @return SubjectInterface
     */
    public function getTranslation($language_id);

    /**
     * Indica se è presente la traduzione in una determinata lingua
     *
     * @param $language_id
     * @return bool
     */
    public function hasTranslation($language_id);

    /**
     * Imposta la traduzione per la lingua.
     *
     * @param int   $language_id
     * @return bool
     */
    public function setTranslation($language_id, array $attributes);

    /**
     * @param int   $language_id
     */
    public function prepareTranslation($language_id, array $attributes);

    /**
     * @param array $translations in formato "array(language_id => attributes)"
     */
    public function prepareTranslations(array $translations);
}
