<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Application\Admin
 */

namespace Application\Admin\Form;

/**
 * Campo textarea.
 *
 * @deprecated
 */
class TextareaField extends TextField
{
    /**
     * Valore per l’attributo `rows`.
     *
     * @var integer
     */
    protected $rows = 5;

    /**
     * Valore per l’attributo `cols`.
     *
     * @var integer
     */
    protected $cols = 10;

    /**
     * {@inheritdoc}
     */
    protected function generateCode(array $attributes)
    {
        unset($attributes['size']);
        unset($attributes['maxlength']);

        $attributes['rows'] = $this->rows;
        $attributes['cols'] = $this->cols;

        $html = $this->get('subject')->getContainer()->get('template_html');

        return $html->generateTagBlock('textarea', $this->getFieldValue(), $attributes);
    }

    /**
     * {@inheritdoc}
     */
    protected function getFieldClass()
    {
        return false;
    }
}
