<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Application\Admin
 */

namespace Application\Admin\Form;

/**
 * Campo testo.
 *
 * @deprecated
 */
class TextField extends Field
{
    /**
     * {@inheritdoc}
     */
    protected $default = '';

    /**
     * {@inheritdoc}
     */
    public function setAttributeModel()
    {
        $this->model->{$this->attribute_name} = isset($_POST[$this->post_name]) ? trim((string) $_POST[$this->post_name]) : $this->default;
    }

    /**
     * {@inheritdoc}
     */
    public function getViewCode()
    {
        $attributes = array_merge($this->getBaseAttributes(), [
            'name' => $this->post_name,
            'id'   => 'field-' . $this->post_name,
        ]);

        if (($class = $this->getFieldClass())) {
            $attributes['class'] = $class;
        }

        $columns = $this->model->columns();
        if (
            array_key_exists($this->attribute_name, $columns)
            && $columns[$this->attribute_name]->length
        ) {
            $attributes['size'] = $columns[$this->attribute_name]->length;
            $attributes['maxlength'] = $columns[$this->attribute_name]->length;
        }

        return $this->generateCode($attributes);
    }

    /**
     * Genera il codice HTML del campo.
     *
     * @return string
     */
    protected function generateCode(array $attributes)
    {
        $attributes['type'] = $this->getFieldType();
        $attributes['value'] = $this->getFieldValue();

        $html = $this->get('subject')->getContainer()->get('template_html');

        return $html->generateTagInline('input', $attributes);
    }

    /**
     * Restituisce il tipo di campo.
     *
     * @return string
     */
    protected function getFieldType()
    {
        return 'text';
    }

    /**
     * Restituisce il valore da inserire nel campo.
     *
     * @return string
     */
    protected function getFieldValue()
    {
        return htmlspecialchars(($this->model->attributePresent($this->attribute_name) ? $this->model->{$this->attribute_name} : $this->default), ENT_QUOTES, 'UTF-8');
    }

    /**
     * Restituisce la classe del campo, oppure ‘false’ se non la si vuole inserire.
     *
     * @return mixed (string/false)
     */
    protected function getFieldClass()
    {
        return 'input_text';
    }
}
