<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Application\Admin
 */

namespace Application\Admin\Form;

/**
 * Campo select.
 *
 * @deprecated
 */
class SelectField extends Field
{
    /**
     * {@inheritdoc}
     */
    protected $default;

    /**
     * Lista delle opzioni da inserire nella select nel formato value/label.
     *
     * @var array
     */
    protected $items;

    /**
     * {@inheritdoc}
     */
    public function setAttributeModel()
    {
        $this->model->{$this->attribute_name} = $_POST[$this->post_name] ?? $this->default;
    }

    /**
     * {@inheritdoc}
     */
    public function getViewCode()
    {
        $this->setItems();
        $attribute_value = $this->model->{$this->attribute_name};

        if (is_null($attribute_value)) {
            $attribute_value = $this->default;
        }

        $attributes = array_merge($this->getBaseAttributes(), [
            'name' => $this->post_name,
            'id'   => $this->post_name,
        ]);

        $html = $this->get('subject')->getContainer()->get('template_html');

        return $html->generateTagBlock('select', $html->select($this->items, $attribute_value), $attributes);
    }

    /**
     * Imposta le opzioni per la select.
     *
     * @return void
     */
    protected function setItems()
    {
        if ($this->items === null) {
            $this->items = $this->get('items', []);
        }
    }
}
