<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Form\Repeater;

use Pongho\Form\BaseField;
use Pongho\Form\Fieldset;
use Pongho\Form\Repeater\NestedSortableInterface;
use Pongho\Form\Repeater\SortableInterface;

class RowMain extends Fieldset
{
    /**
     * {@inheritdoc}
     */
    public function getId()
    {
        return 'repeater-' . $this->getPath();
    }

    /**
     * {@inheritdoc}
     */
    public function getStartCode()
    {
        $handle = '';
        $this_row_repeater = $this->getParent()->getParent();

        if (($this_row_repeater instanceof SortableInterface) || ($this_row_repeater instanceof NestedSortableInterface) && !$this->isReadonly()) {
            $handle = '<div class="sortable-handle"></div>';
        }

        $this->addCssClass('repeater-main');

        $code = '<div' . $this->getAttributesCode() . '>' . $handle . '<div class="repeater-fields">';

        $row = $this->getParent();
        if ($row->hasSetting('title')) {
            $title = $row->getSetting('title');

            if (is_callable($title)) {
                $code .= call_user_func($title, $row);
            } else {
                $code .= $title;
            }
        }

        // Imposto la label come placeholder dei campi
        /** @var \Pongho\Form\BaseField|\Pongho\Form\Fieldset $field */
        foreach ($this->getFields() as $field) {
            if (!$field->hasAttribute('placeholder')) {
                $field->setAttribute('placeholder', $field->getLabel());
            }
        }

        return $code;
    }

    /**
     * {@inheritdoc}
     */
    public function getContentCode()
    {
        $code = '';

        $row = $this->getParent();

        if ($row->hasSetting('title')) {
            $title = $row->getSetting('title');

            if (is_callable($title)) {
                $code .= call_user_func($title, $row);
            } else {
                $code .= $title;
            }
        }

        /** @var \Pongho\Form\BaseField|\Pongho\Form\Fieldset $field */
        foreach ($this->getFields() as $field) {
            if (!$field->hasAttribute('placeholder')) {
                $field->setAttribute('placeholder', $field->getLabel());
            }

            if ($field instanceof BaseField) {
                $code .= $field->render();
            } else {
                /** @var \Pongho\Form\Fieldset $field */
                $code .= $field->getContentCode();
            }
        }

        return $code;
    }

    /**
     * {@inheritdoc}
     */
    public function getEndCode()
    {
        $actions = '';

        $row = $this->getParent();

        if (!$row->getSetting('hide-open', false)) {
            $actions .= '<a href="#" class="repeater-actions-open">' . $row->getSetting('open-label', '') . '</a>'
                . '<a href="#" class="repeater-actions-close">' . $row->getSetting('close-label', '') . '</a>';
        }

        if ($row->getSetting('show-delete', false) && !$row->isReadonly()) {
            $delete_confirm = $row->hasSetting('delete-confirm') ? ' data-confirm="' . $row->getSetting('delete-confirm') . '"' : '';

            $actions .= '<a href="#" class="repeater-delete-row"' . $delete_confirm . '>' . $row->getSetting('delete-label', '') . '</a>';
        }

        return '</div><div class="repeater-actions">' . $actions . '</div></div>';
    }
}
