<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Form\Repeater;

use Pongho\Form\Fieldset;

class RowContent extends Fieldset
{
    /**
     * {@inheritdoc}
     */
    public function getId()
    {
        return 'repeater-' . $this->getPath();
    }

    /**
     * {@inheritdoc}
     */
    public function getStartCode()
    {
        $this->addCssClass('repeater-content');

        return '<div' . $this->getAttributesCode() . '><div class="repeater-fields">';
    }

    /**
     * {@inheritdoc}
     */
    public function getEndCode()
    {
        $options = '';

        $row = $this->getParent();

        if (!$row->getSetting('hide-options', false) && !$row->isReadonly()) {
            $delete_confirm = ($row->hasSetting('delete-confirm') ? ' data-confirm="' . $row->getSetting('delete-confirm') . '"' : '');

            $options .= '<div class="repeater-options"><a href="#" class="repeater-delete-row"' . $delete_confirm . '>'
                . $row->getSetting('delete-label', '<span>X</span>') . '</a></div>';
        }

        return '</div>' . $options . '</div>';
    }
}
