<?php

namespace Application\Admin\Form\LinkField;

use Application\Cms\Model\Node;
use Application\Cms\Model\NodeType;
use Application\Core\Model\LanguageSite;
use Application\Core\Model\LinkType;
use Pongho\Core\Kernel;

/**
 * @deprecated
 */
class NodeHandler extends BaseHandler
{
    /** @var \Application\Cms\Model\NodeType[] */
    private $nodes_types = [];

    /** @var \Application\Cms\Model\Node[] */
    private $nodes = [];

    /**
     * {@inheritdoc}
     */
    public function getClass($type = '')
    {
        return static::class . '::' . 'node-' . $type;
    }

    /**
     * {@inheritdoc}
     */
    public function addTypesOptions($language_id, array $options)
    {
        foreach ($this->getNodesTypes($language_id) as $node_type) {
            if (!$node_type->is_menu_enabled) {
                continue;
            }

            $options[$this->getClass($node_type->node_type)] = 'node-' . $node_type->node_type;
        }

        return $options;
    }

    /**
     * {@inheritdoc}
     */
    public function render($name, $language_id, ?LinkType $link_type = null)
    {
        $blocks = [];

        /** @var \Pongho\Template\Html $html */
        $html = Kernel::instance()->getContainer()->get('template_html');

        foreach ($this->getNodesTypes($language_id) as $node_type) {
            if (!$node_type->is_menu_enabled) {
                continue;
            }

            $blocks['node-' . $node_type->node_type] = '<select name="' . $name . '[node-' . $node_type->node_type . ']">' . $html->selectHierarchy(
                $this->getNodes($node_type, $language_id),
                ($link_type instanceof LinkType ? $link_type->model_id : null)
            ) . '</select>';
        }

        return $blocks;
    }

    /**
     * {@inheritdoc}
     */
    public function renderSpan($name, $language_id, ?LinkType $link_type = null)
    {
        $blocks = [];

        foreach ($this->getNodesTypes($language_id) as $node_type) {
            if (!$node_type->is_menu_enabled) {
                continue;
            }

            $key = 'node-' . $node_type->node_type;
            $blocks[$key] = '<span data-name="' . $name . '[' . $key . ']" data-value="' . ($link_type instanceof LinkType ? $link_type->model_id : '') . '" data-language="' . $language_id . '"></span>';
        }

        return $blocks;
    }

    /**
     * {@inheritdoc}
     */
    public function getSelectOptions($language_id, array $query_options = [])
    {
        $options = [];

        /** @var \Pongho\Template\Html $html */
        $html = Kernel::instance()->getContainer()->get('template_html');

        foreach ($this->getNodesTypes($language_id) as $node_type) {
            if (!$node_type->is_menu_enabled) {
                continue;
            }

            $options['node-' . $node_type->node_type] = $html->selectHierarchy($this->getNodes($node_type, $language_id));
        }

        return $options;
    }

    /**
     * Ricava i tipi di nodo del sito
     *
     * @param $language_id
     * @return mixed
     */
    private function getNodesTypes($language_id)
    {
        if (!array_key_exists($language_id, $this->nodes_types)) {
            $this->nodes_types[$language_id] = NodeType::findAll($this->site_id, $language_id);
        }

        return $this->nodes_types[$language_id];
    }

    /**
     * Ricava i nodi del tipo di nodo
     *
     * @param          $language_id
     * @return mixed
     */
    private function getNodes(NodeType $type, $language_id)
    {
        if (!isset($this->nodes[$type->id][$language_id])) {
            $options = [
                'conditions' => [
                    "`from`.module_site_id = :module_site AND `from`.status IN ('publish', 'home') AND t.is_enabled = :enabled",
                    'module_site' => $type->id,
                    'enabled'     => true,
                ],
            ];

            $nodes = [];
            foreach (Node::all($options, $language_id) as $node) {
                $nodes[$node->parent_id][$node->id] = $node->title;
            }

            $this->nodes[$type->id][$language_id] = $nodes;
        }

        return $this->nodes[$type->id][$language_id];
    }

    /**
     * {@inheritdoc}
     */
    public static function parseAttributes(array $attributes)
    {
        $key = $attributes['link_type'];

        if (array_key_exists($key, $attributes)) {
            $attributes['model_id'] = $attributes[$key];

            $node = Node::find($attributes['model_id'], $attributes['language_id']);

            $attributes['model_path'] = $node->permalink;
        }

        return $attributes;
    }

    /**
     * {@inheritdoc}
     */
    public static function getResource(LinkType $link_type)
    {
        return get_node($link_type->model_id);
    }

    /**
     * {@inheritdoc}
     */
    public static function getTitle(LinkType $link_type)
    {
        $node = static::getResource($link_type);

        if ($node) {
            return $node->title();
        }

        return parent::getTitle($link_type);
    }
}
