<?php

namespace Application\Admin\Form\LinkField;

use Application\Core\Model\LanguageModule;
use Application\Core\Model\LinkType;
use Application\Core\Model\ModuleSite;
use Pongho\Core\Kernel;

/**
 * @deprecated
 */
class ModuleHandler extends BaseHandler
{
    private $modules = [];

    /**
     * {@inheritdoc}
     */
    public function getClass($type = '')
    {
        return static::class . '::module';
    }

    /**
     * {@inheritdoc}
     */
    public function addTypesOptions($language_id, array $options)
    {
        $options[$this->getClass()] = 'module';

        return $options;
    }

    /**
     * {@inheritdoc}
     */
    public function render($name, $language_id, ?LinkType $link_type = null)
    {
        /** @var \Pongho\Template\Html $html */
        $html = Kernel::instance()->getContainer()->get('template_html');

        return [
            'module' => '<select name="' . $name . '[module_id]">' . $html->select($this->getModules($language_id), ($link_type instanceof inkType ? $link_type->model_id : null)) . '</select>',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function renderSpan($name, $language_id, ?LinkType $link_type = null)
    {
        return [
            'module' => '<span data-name="' . $name . '[module_id]" data-value="' . ($link_type instanceof LinkType ? $link_type->model_id : '') . '" data-language="' . $language_id . '"></span>',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function getSelectOptions($language_id, array $query_options = [])
    {
        $blocks = [];

        /** @var \Pongho\Template\Html $html */
        $html = Kernel::instance()->getContainer()->get('template_html');

        $blocks['module'] = $html->select($this->getModules($language_id));

        return $blocks;
    }

    /**
     * Ricava i moduli del sito
     *
     * @param $language_id
     * @return mixed
     */
    private function getModules($language_id)
    {
        if (!array_key_exists($language_id, $this->modules)) {
            $modules = [];

            foreach (ModuleSite::findAll($this->site_id, $language_id) as $module) {
                $modules[$module->module_id] = $module->name;
            }

            $this->modules[$language_id] = $modules;
        }

        return $this->modules[$language_id];
    }


    /**
     * {@inheritdoc}
     */
    public static function parseAttributes(array $attributes)
    {
        if (array_key_exists('module_id', $attributes)) {
            $attributes['model_id'] = $attributes['module_id'];

            $language_module = LanguageModule::findByLanguageAndSiteAndModule(
                $attributes['language_id'],
                $attributes['site_id'],
                $attributes['module_id']
            );

            if ($language_module !== null) {
                $attributes['model_path'] = $language_module->path;
            }
        }

        return $attributes;
    }

    /**
     * {@inheritdoc}
     */
    public static function getResource(LinkType $link_type)
    {
        /** @var \Application\Core\Model\Site $site */
        $site = Kernel::instance()->getContainer()->get('site');

        /** @var \Application\Core\Localization $language */
        $language = Kernel::instance()->getContainer()->get('language');

        return ModuleSite::findById($link_type->model_id, $site->id, $language->getLanguageId());
    }

    /**
     * {@inheritdoc}
     */
    public static function getTitle(LinkType $link_type)
    {
        $module = static::getResource($link_type);

        if ($module) {
            return $module->name;
        }

        return '';
    }
}
