<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Admin\Form\LinkField;

use Application\Cms\Model\Menu;
use Application\Core\Model\LinkType;
use Pongho\Core\Kernel;

/**
 * @deprecated
 */
class MenuHandler extends BaseHandler
{
    /**
     * {@inheritdoc}
     */
    public function getClass($type = '')
    {
        return static::class . '::menu';
    }

    /**
     * {@inheritdoc}
     */
    public function addTypesOptions($language_id, array $options)
    {
        $options[$this->getClass()] = 'menu';

        return $options;
    }

    /**
     * {@inheritdoc}
     */
    public function render($name, $language_id, ?LinkType $link_type = null)
    {
        /** @var \Pongho\Template\Html $html */
        $html = Kernel::instance()->getContainer()->get('template_html');

        $menu_id = $link_type instanceof LinkType ? $link_type->model_id : null;

        return [
            'menu' => '<select name="' . $name . '">' . $html->select($this->getMenus($menu_id), $menu_id) . '</select>',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function renderSpan($name, $language_id, ?LinkType $link_type = null)
    {
        return [
            'menu' => '<span data-name="' . $name . '[menu_id]" data-value="' . ($link_type instanceof LinkType ? $link_type->model_id : '') . '" data-language="' . $language_id . '"></span>',
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function getSelectOptions($language_id, array $query_options = [])
    {
        /** @var \Pongho\Template\Html $html */
        $html = Kernel::instance()->getContainer()->get('template_html');

        return ['menu' => $html->select($this->getMenus($query_options))];
    }

    /**
     * @internal param int $menu_id
     * @return array
     */
    protected function getMenus(array $query_options = [])
    {
        /** @var \Application\Core\Model\Site $site */
        $site = Kernel::instance()->getContainer()->get('site');

        $options = Menu::addCondition($query_options, ['site_id = :site', 'site' => $site->id]);

        $menus = [];

        /** @var \Application\Cms\Model\Menu $menu */
        foreach (Menu::all($options) as $menu) {
            $menus[$menu->id] = $menu->title;
        }

        return $menus;
    }

    /**
     * {@inheritdoc}
     */
    public static function parseAttributes(array $attributes)
    {
        if (array_key_exists('menu_id', $attributes)) {
            $attributes['model_id'] = $attributes['menu_id'];
        }

        return $attributes;
    }

    /**
     * {@inheritdoc}
     */
    public static function getResource(LinkType $link_type)
    {
        return get_menu($link_type->model_id);
    }

    /**
     * {@inheritdoc}
     */
    public static function getTitle(LinkType $link_type)
    {
        /** @var \Application\Cms\Model\Menu $menu */
        if ($menu = Menu::find($link_type->model_id)) {
            return $menu->name;
        }

        return '';
    }
}
