<?php

namespace Application\Admin\Form\LinkField;

use Application\Core\Model\LinkType;

/**
 * @deprecated
 */
class LinkHandler extends BaseHandler
{
    /**
     * {@inheritdoc}
     */
    public function getClass($type = '')
    {
        return static::class . '::link';
    }

    /**
     * {@inheritdoc}
     */
    public function addTypesOptions($language_id, array $options)
    {
        $options[$this->getClass()] = 'link';

        return $options;
    }

    /**
     * {@inheritdoc}
     */
    public function render($name, $language_id, ?LinkType $link_type = null)
    {
        if (!$link_type instanceof LinkType) {
            return ['link' => '<input type="text" name="' . $name . '[model_path]" class="input_text">'];
        }

        return ['link' => '<input type="text" name="' . $name . '[model_path]" value="' . $link_type->model_path . '" class="input_text">'];
    }

    /**
     * {@inheritdoc}
     */
    public function renderSpan($name, $language_id, ?LinkType $link_type = null)
    {
        return $this->render($name, $language_id, $link_type);
    }

    /**
     * {@inheritdoc}
     */
    public function getSelectOptions($language_id, array $query_options = [])
    {
        return [];
    }

    /**
     * {@inheritdoc}
     */
    public static function parseAttributes(array $attributes)
    {
        $attributes['model_path'] = normalize_url($attributes['model_path']);

        return $attributes;
    }

    /**
     * {@inheritdoc}
     */
    public static function getTitle(LinkType $link_type)
    {
        return static::getPermalink($link_type);
    }
}
