<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Admin\Form;

use Pongho\Form\Field;
use Pongho\Form\Fieldset;

class FormBuilder extends \Pongho\Form\Utilities\FormBuilder
{
    /**
     * {@inheritdoc}
     */
    protected static function buildField(Field $field, $options)
    {
        if ($field instanceof TranslationsManagerInterface) {
            /** @var Fieldset|TranslationsManagerInterface $field */

            /**
             * Permette di impostare la descrizione del campo se specificata
             */
            if (isset($options['description'])) {
                $field->setDescription($options['description']);
            }

            /**
             * Permette di impostare gli attributi del campo
             */
            if (isset($options['attributes'])) {
                $field->setAttributes($options['attributes']);
            }

            /**
             * Permette di impostare le impostazioni aggiuntive per il controllo del comportamento di un campo
             */
            if (isset($options['settings'])) {
                $field->setSettings($options['settings']);
            }

            // Campi
            if (!isset($options['fields'])) {
                throw new \LogicException('Missing fields.'); // Ci stava un MissingValueException
            } elseif (!is_array($options['fields'])) {
                throw new \InvalidArgumentException(
                    sprintf('Option "fields" must be an array. "%s" given.', gettype($options['fields']))
                );
            }

            $field->build($options['fields']);

            return $field;
        }

        return parent::buildField($field, $options);
    }
}
